# Preparation Stage
## Model Download
All models used in this program are open-source and can be downloaded from Huggingface.
## Relative Representation Matrix Construction
To construct the relative representation matrix, use the following command:
```bash
python src/transfer_matrix_save.py
```
## Configuration File Setup
Based on the examples in the `confs` folder, fill in the configuration file according to the task requirements, the model, and the newly constructed relative representation matrix. The configuration file should include the following fields:

- `model_path`: Path to the model
- `probability_transfer_matrix_path`: Path to the relative representation matrix constructed in the previous step
- `file_path`: Paths to the example prompt and the validation and test datasets
- `prompt_template`: Prompt template
- `result_process_parameter`: Post-processing operation parameters
# Execution Stage
For a four-model ensemble, run the TriviaQA test with the following script:
```bash
CUDA_VISIBLE_DEVICES=0,1 python src/main_4ensemble_llama_series_local_matrix.py \
--config confs/G0003/TriviaQA/LLaMA+Mistral+InternLM+Tigerbot.json \
-lpm based_on_probility_transfer_logits_local_reweight_processor \
-d0 cuda:0 -d1 cuda:0 -d2 cuda:1 -d3 cuda:1 -dp cuda:0 \
-rsd eval/TriviaQA_old_version_0506/LLaMA+Mistral+InternLM+Tigerbot/reweight/test \
-rm test \
-lr 0.2
```
Where:

- `-lpm`: Model ensemble strategy, detailed in `src/logits_processor/model_processor_factory.py`
- `-rsd`: Result storage path
- `-rm`: Running mode, either `dev` or `test`
- `-lr`: Learning rate
# Testing Stage
To perform testing, use the following command:
```bash
python utils/evaluate/NQ_dir_test.py eval/TriviaQA_old_version_0506/LLaMA+Mistral+InternLM+Tigerbot/reweight/test
```
Result:
```
Found 0 missing predictions.
Accuracy: 75.67 (4540/6000)
```

